% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngbfor.R
\name{NGBforecast}
\alias{NGBforecast}
\title{NGBoost forecasting class}
\value{
An NGBforecast class
}
\description{
The main forecasting class.
}
\examples{
\dontrun{

library(ngboostForecast)

model <- NGBforecast$new(Dist = Dist("Normal"),
                         Base = sklearner(module = "linear_model",
                         class = "Ridge"),
                         Score = Scores("LogScore"),
                         natural_gradient = TRUE,
                         n_estimators = 200,
                         learning_rate =  0.1,
                         minibatch_frac = 1,
                         col_sample = 1,
                         verbose = TRUE,
                         verbose_eval = 100,
                         tol = 1e-5)
model$fit(y = AirPassengers, seasonal = TRUE, max_lag = 12, xreg = NULL,
early_stopping_rounds = 10L)
fc <- model$forecast(h = 12, level = c(90, 80), xreg = NULL)

autoplot(fc)
}

}
\references{
Duan, T et. al. (2019), NGBoost: Natural Gradient Boosting for Probabilistic
Prediction.
}
\author{
Resul Akay
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NGBforecast-new}{\code{NGBforecast$new()}}
\item \href{#method-NGBforecast-fit}{\code{NGBforecast$fit()}}
\item \href{#method-NGBforecast-forecast}{\code{NGBforecast$forecast()}}
\item \href{#method-NGBforecast-feature_importances}{\code{NGBforecast$feature_importances()}}
\item \href{#method-NGBforecast-plot_feature_importance}{\code{NGBforecast$plot_feature_importance()}}
\item \href{#method-NGBforecast-get_params}{\code{NGBforecast$get_params()}}
\item \href{#method-NGBforecast-clone}{\code{NGBforecast$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-new"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-new}{}}}
\subsection{Method \code{new()}}{
Initialize an NGBforecast model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$new(
  Dist = NULL,
  Score = NULL,
  Base = NULL,
  natural_gradient = TRUE,
  n_estimators = as.integer(500),
  learning_rate = 0.01,
  minibatch_frac = 1,
  col_sample = 1,
  verbose = TRUE,
  verbose_eval = as.integer(100),
  tol = 1e-04,
  random_state = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Dist}}{Assumed distributional form of \code{Y|X=x}. An output of
\code{\link{Dist}} function, e.g. \code{Dist('Normal')}}

\item{\code{Score}}{Rule to compare probabilistic predictions to
the observed data. A score from \code{\link{Scores}} function, e.g.
\code{Scores(score = "LogScore")}.}

\item{\code{Base}}{Base learner. An output of \code{\link{sklearner}} function,
e.g. \code{sklearner(module = "tree", class = "DecisionTreeRegressor", ...)}}

\item{\code{natural_gradient}}{Logical flag indicating whether the natural
gradient should be used}

\item{\code{n_estimators}}{The number of boosting iterations to fit}

\item{\code{learning_rate}}{The learning rate}

\item{\code{minibatch_frac}}{The percent subsample of rows to use in each
boosting iteration}

\item{\code{col_sample}}{The percent subsample of columns to use in each
boosting iteration}

\item{\code{verbose}}{Flag indicating whether output should be printed
during fitting. If TRUE it will print logs.}

\item{\code{verbose_eval}}{Increment (in boosting iterations) at which
output should be printed}

\item{\code{tol}}{Numerical tolerance to be used in optimization}

\item{\code{random_state}}{Seed for reproducibility.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An NGBforecast object that can be fit.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-fit"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the initialized model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$fit(
  y,
  max_lag = 5,
  xreg = NULL,
  test_size = NULL,
  seasonal = TRUE,
  K = frequency(y)/2 - 1,
  train_loss_monitor = NULL,
  val_loss_monitor = NULL,
  early_stopping_rounds = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{A time series (ts) object}

\item{\code{max_lag}}{Maximum number of lags}

\item{\code{xreg}}{Optional. A numerical matrix of external regressors,
which must have the same number of rows as y.}

\item{\code{test_size}}{The length of validation set.
If it is NULL, then, it is automatically specified.}

\item{\code{seasonal}}{Boolean. If \code{seasonal = TRUE} the fourier terms
will be used for modeling seasonality.}

\item{\code{K}}{Maximum order(s) of Fourier terms, used only if
\code{seasonal = TRUE}.}

\item{\code{train_loss_monitor}}{A custom score or set of scores to track on the
training set during training. Defaults to the score defined in the NGBoost
constructor. Please do not modify unless you know what you are doing.}

\item{\code{val_loss_monitor}}{A custom score or set of scores to track on the
validation set during training. Defaults to the score defined in the
NGBoost  constructor. Please do not modify unless you know what you are
doing.}

\item{\code{early_stopping_rounds}}{The number of consecutive boosting
iterations during which the loss has to increase before the algorithm
stops early.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-forecast"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-forecast}{}}}
\subsection{Method \code{forecast()}}{
Forecast the fitted model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$forecast(h = 6, xreg = NULL, level = c(80, 95), data_frame = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{h}}{Forecast horizon}

\item{\code{xreg}}{A numerical vector or matrix of external regressors}

\item{\code{level}}{Confidence level for prediction intervals}

\item{\code{data_frame}}{Bool. If TRUE, forecast will be returned as a
data.frame object, if FALSE it will return a forecast class. If TRUE,
\code{\link{autoplot}} will function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-feature_importances"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-feature_importances}{}}}
\subsection{Method \code{feature_importances()}}{
Return the feature importance for all parameters in the
distribution (the higher, the more important the feature).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$feature_importances()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-plot_feature_importance"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-plot_feature_importance}{}}}
\subsection{Method \code{plot_feature_importance()}}{
Plot feature importance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$plot_feature_importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A ggplot object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-get_params"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-get_params}{}}}
\subsection{Method \code{get_params()}}{
Get parameters for this estimator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$get_params(deep = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{bool, default = TRUE
If True, will return the parameters for this estimator and
contained subobjects that are estimators.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A named list of parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecast-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecast-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecast$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
