% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nieve-package.R
\docType{package}
\name{nieve-package}
\alias{nieve-package}
\title{\packageTitle{nieve}}
\description{
The DESCRIPTION file:
\packageDESCRIPTION{nieve}
\packageIndices{nieve}

The \pkg{nieve} package provides utility functions for Extreme
Value Analysis. It includes the probability functions for the
two-parameter Generalized Pareto Distribution (GPD) and for the
three-parameter Generalized Extreme Value (GEV)
distribution. These functions are vectorized w.r.t. the parameters
and optionally provide the exact derivatives w.r.t. the
parameters: gradient and Hessian which can be used in optimization
e.g., to maximize the log-likelihood. Since the gradient is
available for the distribution function, the exact gradient of the
log-likelihood function is available even when censored
observations are used.

These functions should behave like the probability functions of
the \pkg{stats} package: when a probability \code{p = 0.0} or
\code{p = 1.0} is given, the quantile functions should return the
lower and the upper end-point, be they finite or not. Also when
evaluated at \code{-Inf} and \code{Inf} the probability functions
should return \code{0.0} and \code{1.0}.

The \pkg{nieve} package was partly funded by the French
\emph{Institut de Radioprotection et Sûreté
Nucléaire (IRSN)} and some of the code formerly was part of R
packages owned by the IRSN \emph{Bureau d'Expertise en
Hydrogéologie et sur les Risques d'Inondation, météorologiques et
Géotechniques} (Behrig).
}
