% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPriors.R
\name{setPriors}
\alias{setPriors}
\title{Set up prior values for different categories of nodes}
\usage{
setPriors(
  intercept = quote(dnorm(0, sd = 1000)),
  coefficient = quote(dnorm(0, sd = 1000)),
  sd = quote(dunif(0, 100)),
  factor = NULL,
  continuous = NULL,
  lkjShape = 1,
  ...
)
}
\arguments{
\item{intercept}{Prior specification for intercepts}

\item{coefficient}{Prior specfication for slope coefficients}

\item{sd}{Prior specification for random effects SDs}

\item{factor}{Prior specifications for slope coefficients corresponding
to factor data}

\item{continuous}{Prior specifications for slope coefficients corresponding
to continuous data}

\item{lkjShape}{Value of shape parameter for LKJ distribution prior, used for
correlation matrix in correlated random slope and intercept models}

\item{...}{Specific parameters, optionally with brackets/indices}
}
\value{
A named list of prior specifications to be passed to the \code{priors}
 argument of other macros in the package, such as \code{LINPRED}.
}
\description{
Generates a list of custom specifications of priors for parameters in the model.
It is possible to set priors for a category of parameters (e.g., intercept,
coefficient, sd, factor, continuous) or to set a prior for a specific
parameter name (optionally including brackets with indices).
}
\details{
Exact name matches including brackets/indices are used first, followed by
name matches without indices, followed by data type (factor/continuous)
followed by parameter type (intercept/coefficient/sd).
Arguments can be supplied as quoted code, a character string, or
as a list of prior components. For example, to specify the prior
\code{dnorm(0, sd = 10)} you could specify \code{quote(dnorm(0, sd = 10))},
or \code{"dnorm(0, sd = 10)"}, or \code{list("dnorm", 0, sd = 10)}.
}
\examples{
# Set a prior for intercept terms using quoted code
setPriors(intercept = quote(dunif(-5,5)))
# Instead using a character string
setPriors(intercept = "dunif(-5,5)")
# Set prior for slopes associated with factor covariates
setPriors(factor = quote(dnorm(0, sd = 2.5)))
# Set prior for a specific coefficient
setPriors('alpha[1]' = "dnorm(0, 3)")

}
\seealso{
[nimble::dlkj_corr_cholesky] for more on the LKJ distribution
}
\author{
Ken Kellner
}
