% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSsharp.R
\name{SSsharp}
\alias{SSsharp}
\alias{sharp}
\title{self start for temperature response}
\usage{
sharp(temp, r_tref, e, el, tl, eh, th, tref = 25)

SSsharp(temp, r_tref, e, el, tl, eh, th, tref = 25)
}
\arguments{
\item{temp}{input vector (x) which is normally \sQuote{temperature}.}

\item{r_tref}{rate at the standardised temperature, tref}

\item{e}{activation energy (eV)}

\item{el}{low temperature de-activation energy (eV)}

\item{tl}{temperature at which the enzyme is half active and half suppressed due to low temperatures}

\item{eh}{high temperature de-activation energy (eV)}

\item{th}{temperature at which enzyme is half active and half suppressed dut to high temperatures}

\item{tref}{standardisation temperature in degrees centigrade. Temperature at which rates are not inactivated by either high or low temperatures. Typically, 25 degrees.}
}
\value{
sharp: vector of the same length as x using a sharp function
}
\description{
Self starter for temperature response function
}
\details{
For details see Schoolfield, R. M., Sharpe, P. J. & Magnuson, C. E. Non-linear regression of biological temperature-dependent rate models based on absolute reaction-rate theory. Journal of Theoretical Biology 88, 719-731 (1981)
}
\note{
I do not recommend using this function.
}
\examples{
\donttest{
require(ggplot2)
require(minpack.lm)

temp <- 0:45
rate <- sharp(temp, 1, 0.03, 1.44, 28, 19, 44) + rnorm(length(temp), 0, 0.05)
dat <- data.frame(temp = temp, rate = rate)
## Fit model
fit <- nlsLM(rate ~ SSsharp(temp, r_tref, e, el, tl, eh, th, tref = 20), data = dat)
## Visualize
ggplot(data = dat, aes(temp, rate)) + geom_point() + geom_line(aes(y = fitted(fit)))

}
}
