X <- toyModel("NMF")
M1 <- kFoldMaskTensor(X, seeds=12345)[[1]]
M2 <- kFoldMaskTensor(X, seeds=54321)[[1]]

out1 <- NMTF(X, M=M1, rank=c(3,4), algorithm="Frobenius", num.iter=2)
out2 <- NMTF(X, M=M1, rank=c(3,4), algorithm="KL", num.iter=2)
out3 <- NMTF(X, M=M1, rank=c(3,4), algorithm="IS", num.iter=2)
out4 <- NMTF(X, M=M1, rank=c(3,4), algorithm="ALS", num.iter=2)
out5 <- NMTF(X, M=M1, rank=c(3,4), algorithm="PG", num.iter=2)
out6 <- NMTF(X, M=M1, rank=c(3,4), algorithm="COD", num.iter=2)
out7 <- NMTF(X, M=M1, rank=c(3,4), algorithm="Beta", Beta=-1, num.iter=2)

expect_equivalent(length(out1), 8)
expect_equivalent(length(out2), 8)
expect_equivalent(length(out3), 8)
expect_equivalent(length(out4), 8)
expect_equivalent(length(out5), 8)
expect_equivalent(length(out6), 8)
expect_equivalent(length(out7), 8)

out8 <- NMTF(X, M=M2, rank=c(3,4), algorithm="Frobenius", num.iter=2)
out9 <- NMTF(X, M=M2, rank=c(3,4), algorithm="KL", num.iter=2)
out10 <- NMTF(X, M=M2, rank=c(3,4), algorithm="IS", num.iter=2)
out11 <- NMTF(X, M=M2, rank=c(3,4), algorithm="ALS", num.iter=2)
out12 <- NMTF(X, M=M2, rank=c(3,4), algorithm="PG", num.iter=2)
out13 <- NMTF(X, M=M2, rank=c(3,4), algorithm="COD", num.iter=2)
out14 <- NMTF(X, M=M2, rank=c(3,4), algorithm="Beta", Beta=-1, num.iter=2)

expect_true(rev(out1$TestRecError)[1] != rev(out8$TestRecError)[1])
expect_true(rev(out2$TestRecError)[1] != rev(out9$TestRecError)[1])
expect_true(rev(out3$TestRecError)[1] != rev(out10$TestRecError)[1])
expect_true(rev(out4$TestRecError)[1] != rev(out11$TestRecError)[1])
expect_true(rev(out5$TestRecError)[1] != rev(out12$TestRecError)[1])
expect_true(rev(out6$TestRecError)[1] != rev(out13$TestRecError)[1])
expect_true(rev(out7$TestRecError)[1] != rev(out14$TestRecError)[1])

out15 <- NMTF(X, M=M2, rank=c(5,4), algorithm="Frobenius", num.iter=2)
out16 <- NMTF(X, M=M2, rank=c(5,4), algorithm="KL", num.iter=2)
out17 <- NMTF(X, M=M2, rank=c(5,4), algorithm="IS", num.iter=2)
out18 <- NMTF(X, M=M2, rank=c(5,4), algorithm="ALS", num.iter=2)
out19 <- NMTF(X, M=M2, rank=c(5,4), algorithm="PG", num.iter=2)
out20 <- NMTF(X, M=M2, rank=c(5,4), algorithm="COD", num.iter=2)
out21 <- NMTF(X, M=M2, rank=c(5,4), algorithm="Beta", Beta=-1, num.iter=2)

expect_true(rev(out1$TestRecError)[1] != rev(out15$TestRecError)[1])
expect_true(rev(out2$TestRecError)[1] != rev(out16$TestRecError)[1])
expect_true(rev(out3$TestRecError)[1] != rev(out17$TestRecError)[1])
expect_true(rev(out4$TestRecError)[1] != rev(out18$TestRecError)[1])
expect_true(rev(out5$TestRecError)[1] != rev(out19$TestRecError)[1])
expect_true(rev(out6$TestRecError)[1] != rev(out20$TestRecError)[1])
expect_true(rev(out7$TestRecError)[1] != rev(out21$TestRecError)[1])
