% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.covtct}
\alias{funs.covtct}
\alias{cov.tctI}
\alias{cov.tctIII}
\alias{cov.tct3}
\alias{cov.tctIV}
\title{Functions for Covariances of the Entries of the 
Types I, III and IV TCTs}
\usage{
cov.tctI(ct, CovN)

cov.tctIII(ct, CovN)

cov.tct3(ct, CovN)

cov.tctIV(ct, CovN)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{CovN}{The \eqn{k^2 \times k^2} covariance matrix of 
row-wise vectorized cell counts of NNCT, \code{ct}.}
}
\value{
Each of these functions returns 
a \eqn{k^2 \times k^2} covariance matrix, 
whose entries are the covariances of
the entries in the TCTs for the corresponding 
type I-IV cell-specific test.
The row and column names are inherited from \code{ct}.
}
\description{
Four functions: \code{cov.tctI}, \code{cov.tctIII}, \code{cov.tct3},
and \code{cov.tctIV}.

These functions return the covariances 
between entries in the TCT for the types I, III, and IV
cell-specific tests in matrix form 
which is of dimension \eqn{k^2 \times k^2}.
The covariance matrix entries are \eqn{cov(T_{ij},T_{kl})}
when \eqn{T_{ij}} values are by default corresponding to 
the row-wise vectorization of TCT. 
The argument \code{CovN} must be the covariance 
between \eqn{N_{ij}} values which are obtained from the NNCT by row-wise
vectorization.
The functions \code{cov.tctIII} and \code{cov.tct3} are equivalent.
These covariances are valid under RL or 
conditional on \eqn{Q} and \eqn{R} under CSR.

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

cov.tctI(ct,covN)
cov.tctIII(ct,covN)
cov.tctIV(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cov.tct}} and \code{\link{cov.nnct}}
}
\author{
Elvan Ceyhan
}
