% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.overall.nnct}
\alias{funs.overall.nnct}
\alias{overall.nnct.ct}
\alias{overall.nnct}
\title{Dixon's Overall Test of Segregation for NNCT}
\usage{
overall.nnct.ct(ct, covN)

overall.nnct(dat, lab, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{overall.nnct.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT, \code{ct};
used in \code{overall.nnct.ct} only.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{overall.nnct} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{overall.nnct} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. 
used in \code{overall.nnct} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The overall chi-squared statistic}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k(k-1)} for this function.}
\item{estimate}{Estimates of the parameters, NNCT, i.e., matrix of the observed \eqn{N_{ij}} values
which is the NNCT.}
\item{est.name,est.name2}{Names of the estimates, former is a longer description of the estimates
than the latter.}
\item{null.value}{Matrix of hypothesized null values for the parameters which are expected values of the
the \eqn{N_{ij}} values in the NNCT.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{overall.nnct.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{overall.nnct} only}
}
\description{
Two functions: \code{overall.nnct.ct} and \code{overall.nnct}.

Both functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
cell counts from the expected values under RL or CSR for all cells (i.e., entries) combined in the NNCT.
That is, each test is Dixon's overall test of segregation based on NNCTs for \eqn{k \ge 2} classes.
This overall test is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{dixon:1994,dixon:NNCTEco2002;textual}{nnspat}.
Both functions exclude the last column of the NNCT (in fact any column will do and last column
is chosen without loss of generality), to avoid ill-conditioning of the covariance matrix (for its inversion
in the quadratic form).

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k(k-1)}, description of the 
alternative with the corresponding null values (i.e., expected values) of NNCT entries, sample estimates (i.e., observed values) of the entries in NNCT.
The functions also provide names of the test statistics, the description of the test and the data set used.

The null hypothesis is that all \eqn{N_{ij}} entries are equal to their expected values under RL or CSR.

See also 
(\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010,ceyhan:jkss-posthoc-2017;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

overall.nnct(Y,cls)
overall.nnct.ct(ct,covN)

overall.nnct(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

overall.nnct(Y,fcls)
overall.nnct.ct(ct,covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

overall.nnct(Y,cls)
overall.nnct.ct(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{overall.seg.ct}}, \code{\link{overall.seg}}, \code{\link{overall.tct.ct}}
and \code{\link{overall.tct}}
}
\author{
Elvan Ceyhan
}
