% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZcell.nnct}
\alias{funsZcell.nnct}
\alias{Zcell.nnct.ct}
\alias{Zcell.nnct}
\title{Dixon's Cell-specific Z Tests of Segregation for NNCT}
\usage{
Zcell.nnct.ct(
  ct,
  varN,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Zcell.nnct(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, 
used in \code{\link{Zcell.nnct.ct}} only}

\item{varN}{The variance matrix for cell counts in the NNCT, \code{ct}; 
used in \code{\link{Zcell.nnct.ct}} only}

\item{alternative}{Type of the alternative hypothesis in the test, 
one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, 
default is \code{0.95}, for the cell counts, i.e.
\eqn{N_{ij}} values}

\item{dat}{The data set in one or higher dimensions,
each row corresponds to a data point,
used in \code{\link{Zcell.nnct}} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical),
used in \code{\link{Zcell.nnct}} only}

\item{\dots}{are for further arguments, 
such as \code{method} and \code{p}, 
passed to the \code{\link[stats]{dist}} function,
used in \code{\link{Zcell.nnct}} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{matrix} of Dixon's cell-specific test statistics}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{matrix} of \eqn{p}-values for 
the hypothesis test for the corresponding alternative}
\item{LCL,UCL}{Matrix of lower and upper confidence levels 
for the cell counts at the given confidence
level \code{conf.level} and depends on the type of \code{alternative}.}
\item{conf.int}{The confidence interval for the estimates, 
it is \code{NULL} here, since we provide the \code{UCL} and \code{LCL}
in \code{matrix} form.}
\item{cnf.lvl}{Level of the upper and 
lower confidence limits of the cell counts,
provided in \code{conf.level}.}
\item{estimate}{Estimates of the parameters, i.e., 
matrix of the observed cell counts which is the NNCT}
\item{est.name,est.name2}{Names of the estimates, 
both are same in this function}
\item{null.value}{Matrix of hypothesized null values 
for the parameters which are expected values of 
the cell counts.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, 
one of \code{"two.sided"}, \code{"less"} or \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, 
returned by \code{\link{Zcell.nnct.ct}} only}
\item{data.name}{Name of the data set, \code{dat}, 
returned by \code{\link{Zcell.nnct}} only }
}
\description{
Two functions: \code{Zcell.nnct.ct} and \code{Zcell.nnct}.

Both functions are objects of class \code{"cellhtest"} 
but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
cell counts from the expected values under RL 
or CSR for each cell (i.e., entry) in the NNCT.
The test for each cell \eqn{i,j} is based on
the normal approximation of the corresponding cell count, \eqn{N_{ij}}
and are due to \insertCite{dixon:1994,dixon:NNCTEco2002;textual}{nnspat}.

Each function yields a contingency table of the test statistics, 
\eqn{p}-values for the corresponding 
alternative, expected values (i.e., null value(s)), 
lower and upper confidence levels, 
sample estimates (i.e., observed values)
for the cell counts and also names of the test statistics, 
estimates, null values, the description of the test, 
and the data set used.

The null hypothesis for each cell \eqn{i,j} is that 
the corresponding cell count is equal to the expected value
under RL or CSR, that is \eqn{E[N_{ii}] = n_i(n_i - 1)/(n - 1)} 
and \eqn{E[N_{ij}] = n_i n_j/(n - 1)}
where \eqn{n_i} is the size of 
class \eqn{i} and \eqn{n} is the size of the data set.

See also 
(\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
varN

Zcell.nnct(Y,cls)
Zcell.nnct(Y,cls,alt="g")

Zcell.nnct.ct(ct,varN)
Zcell.nnct.ct(ct,varN,alt="g")

Zcell.nnct(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Zcell.nnct(Y,cls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

Zcell.nnct(Y,cls)
Zcell.nnct.ct(ct,varN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zcell.nnct.2s}}, \code{\link{Zcell.nnct.rs}}, 
\code{\link{Zcell.nnct.ls}}, \code{\link{Zcell.nnct.pval}},
and \code{\link{Zcell.tct}}
}
\author{
Elvan Ceyhan
}
