% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/024_oned_uni_ln.R
\name{oned_uni_ln}
\alias{oned_uni_ln}
\alias{oned_uni_ln.default}
\alias{oned_uni_ln.formula}
\title{One-dimensional uniform label noise}
\usage{
\method{oned_uni_ln}{default}(
  x,
  y,
  level,
  att,
  lower,
  upper,
  order = levels(y),
  sortid = TRUE,
  ...
)

\method{oned_uni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{att}{an integer with the index of the attribute determining noisy samples.}

\item{lower}{a vector with the lower bound to determine the noisy region of each class.}

\item{upper}{a vector with the upper bound to determine the noisy region of each class.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{One-dimensional uniform label noise} into a classification dataset.
}
\details{
\emph{One-dimensional uniform label noise} is based on the introduction of noise 
according to the values of the attribute \code{att}. Samples of class \emph{i} with  
the attribute \code{att} falling between \code{lower}[i] and \code{upper}[i] 
have a probability \code{level} of being mislabeled. The labels of these samples are randomly
replaced by other different ones within the set of class labels. The order of the class labels is 
determined by \code{order}.
}
\note{
Noise model adapted from the papers in References to multiclass data, considering a 
noise level to control the number of errors in the data
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- oned_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                    level = 0.5, att = 1, lower = c(1.5,2,6), upper = c(2,4,7))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- oned_uni_ln(formula = Species ~ ., data = iris2D, 
                    level = 0.5, att = 1, lower = c(1.5,2,6), upper = c(2,4,7))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
N. Gornitz, A. Porbadnigk, A. Binder, C. Sannelli, M. L. Braun, K. Muller, and M. Kloft. 
\strong{Learning and evaluation in presence of non-i.i.d. label noise}. 
In \emph{Proc. 17th International Conference on Artificial Intelligence and Statistics}, 
volume 33 of PMLR, pages 293–302, 2014. url:\url{https://proceedings.mlr.press/v33/gornitz14.html}.
}
\seealso{
\code{\link{attm_uni_ln}}, \code{\link{qua_uni_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
