% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/040_sym_ddef_ln.R
\name{sym_ddef_ln}
\alias{sym_ddef_ln}
\alias{sym_ddef_ln.default}
\alias{sym_ddef_ln.formula}
\title{Symmetric double-default label noise}
\usage{
\method{sym_ddef_ln}{default}(
  x,
  y,
  level,
  def1 = 1,
  def2 = 2,
  order = levels(y),
  sortid = TRUE,
  ...
)

\method{sym_ddef_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{def1}{an integer with the index of the first default class (default: 1).}

\item{def2}{an integer with the index of the second default class (default: 2).}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric double-default label noise} into a classification dataset.
}
\details{
\emph{Symmetric double-default label noise} randomly selects (\code{level}·100)\% of the samples
in the dataset with independence of their class. Then, the labels of these samples are
replaced by one of two fixed labels (\code{def1} or \code{def2}) within the set of class labels. The indices 
\code{def1} and \code{def2} are taken according to the order given by \code{order}.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_ddef_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)],
                      level = 0.1, order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_ddef_ln(formula = Species ~ ., data = iris2D,
                      level = 0.1, order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
B. Han, J. Yao, G. Niu, M. Zhou, I. W. Tsang, Y. Zhang, and M. Sugiyama. 
\strong{Masking: A new perspective of noisy supervision}. 
In \emph{Advances in Neural Information Processing Systems}, volume 31, pages 5841-5851, 2018.
url:\url{https://proceedings.neurips.cc/paper/2018/hash/aee92f16efd522b9326c25cc3237ac15-Abstract.html}.
}
\seealso{
\code{\link{sym_exc_ln}}, \code{\link{sym_cuni_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
