% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/060_sym_end_an.R
\name{sym_end_an}
\alias{sym_end_an}
\alias{sym_end_an.default}
\alias{sym_end_an.formula}
\title{Symmetric end-directed attribute noise}
\usage{
\method{sym_end_an}{default}(x, y, level, scale = 0.2, sortid = TRUE, ...)

\method{sym_end_an}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{scale}{a double in (0,1) with the scale to be used (default: 0.2).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per attribute.}
\item{idnoise}{an integer vector list with the indices of noisy samples per attribute.}
\item{numclean}{an integer vector with the amount of clean samples per attribute.}
\item{idclean}{an integer vector list with the indices of clean samples per attribute.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric end-directed attribute noise} into a classification dataset.
}
\details{
For each attribute \emph{A}, \emph{Symmetric end-directed attribute noise} computes a
value \code{k} = \code{scale}·\emph{max}(\emph{A}). Then, it chooses (\code{level}·100)\% of the values of that
attribute. For each value, it applies the following procedure:
\itemize{
   \item If the value is less than the median of the attribute, the value transforms into
   adding \code{k} to the maximum of the attribute \emph{A}.
   \item If the value is greater than the median of the attribute, the value transforms into 
   subtracting \code{k} from the minimum of the attribute \emph{A}.
   \item If the value matches the median, one of the two previous alternatives is chosen.
}
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_end_an(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_end_an(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
T. M. Khoshgoftaar and J. V. Hulse. 
\strong{Empirical case studies in attribute noise detection}. 
\emph{IEEE Transactions on Systems, Man and Cybernetics Part C: Applications and Reviews}, 39(4):379-388, 2009.
\doi{10.1109/TSMCC.2009.2013815}.
}
\seealso{
\code{\link{sym_sgau_an}}, \code{\link{symd_gau_an}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
