% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/068_symd_uni_an.R
\name{symd_uni_an}
\alias{symd_uni_an}
\alias{symd_uni_an.default}
\alias{symd_uni_an.formula}
\title{Symmetric/dependent uniform attribute noise}
\usage{
\method{symd_uni_an}{default}(x, y, level, sortid = TRUE, ...)

\method{symd_uni_an}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per attribute.}
\item{idnoise}{an integer vector list with the indices of noisy samples per attribute.}
\item{numclean}{an integer vector with the amount of clean samples per attribute.}
\item{idclean}{an integer vector list with the indices of clean samples per attribute.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric/dependent uniform attribute noise} into a classification dataset.
}
\details{
\emph{Symmetric/dependent uniform attribute noise} corrupts (\code{level}·100)\% of the samples 
in the dataset.  
Their attribute values are replaced by random different ones between
the minimum and maximum of the domain of each attribute following a uniform distribution (for numerical
attributes) or choosing a random value (for nominal attributes).
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- symd_uni_an(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- symd_uni_an(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
A. Petety, S. Tripathi, and N. Hemachandra. 
\strong{Attribute noise robust binary classification}. 
In \emph{Proc. 34th AAAI Conference on Artificial Intelligence}, pages 13897-13898, 2020.
}
\seealso{
\code{\link{sym_uni_an}}, \code{\link{sym_cuni_an}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
