% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_first_minimum_density.R
\name{calculate_first_minimum_density}
\alias{calculate_first_minimum_density}
\title{Function to find the first local minimum of the density of a vector}
\usage{
calculate_first_minimum_density(
  mat,
  log.transform = TRUE,
  adjust = 2,
  makeplots = FALSE
)
}
\arguments{
\item{mat}{matrix whose columns will be used; usually an expression matrix; it
can also be a vector}

\item{log.transform}{whether to log-transform the data before the density estimation;
default is TRUE}

\item{adjust}{adjust factor for the smoothing, passed to density(); default is 2}

\item{makeplots}{a logical value of whether a plot with a vertical line on the minimum found
should be printed for each column of the matrix.}
}
\value{
The function outputs a single value corresponding to the median of the minima calculated
for each column of the matrix. floor() is taken as a conservative estimate
}
\description{
This function is used to estimate the first local minimum of the
density of a vector.
It is meant to be used on the distribution of expression of genes in a sample;
since the distribution tails off, finding the global minimum is not appropriate.
The plot option can be used to visualise the process.
}
\examples{
calculate_first_minimum_density(
  matrix(c(rep(0,100),rep(3,30),rep(10,50),12,13,15,20),ncol=1),
  log.transform=FALSE, makeplots=TRUE
)

}
