% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_aug_functions.R
\name{cace}
\alias{cace}
\title{Compute the Posterior Distribution of the CACE}
\usage{
cace(chain, outcome_model, strong_access)
}
\arguments{
\item{chain}{a matrix containing the draws from the posterior distribution of the model parameters.
The matrix should either be the result of a call to \code{compliance_chain} or have the same
structure as one.}

\item{outcome_model}{a character string indicating which outcome model was used in fitting the model,
either "binary" for a dichotomous outcome or "normal" for the Normal model.}

\item{strong_access}{a logical indicating whether the strong access monotonicity assumption was
made when fitting the model}
}
\value{
a vector containing the draws from the posterior distribution of the CACE
}
\description{
\code{cace} takes a sample from the posterior distribution of the model parameters
and computes the corresponding posterior distribution of the Complier Average Causal Effect.
}
\examples{
# CACE based on a subset of the vitaminA dataset
set.seed(4923)
chain <- compliance_chain(vitaminA[sample(1:nrow(vitaminA), 1000),], outcome_model = "binary",
 exclusion_restriction = TRUE, strong_access = TRUE, n_iter = 10, n_burn = 1)

cace(chain, outcome_model = "binary", strong_access = TRUE)

# matrix representing the samples from the posterior distribution of the model parameters
posterior_mat <- matrix(rnorm(10*8, mean = 10), nrow = 10, ncol = 8)
cace(posterior_mat, "normal", strong_access = TRUE)

}

