% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_crp_mixture.r
\name{cluster_datapoints}
\alias{cluster_datapoints}
\title{Gibbs sampling for the Chinese Restaurant Process
Implementation details can be found in the associated paper
The algorithm stops at every 1000th iteration and prints
the current cluster configuration.}
\usage{
cluster_datapoints(
  data,
  sd = 1,
  initialisation = rep(1, nrow(data)),
  sigma0 = matrix(c(1, 0, 0, 1), nrow = 2, byrow = TRUE)
)
}
\arguments{
\item{data}{A matrix of nx2 containing the datapoints}

\item{sd}{Prior standard deviation}

\item{initialisation}{Cluster initialisation for each datapoint.
Default initialisation is to set every point in the same cluster.}

\item{sigma0}{Covariance matrix for the points. Default initialisation
is set to matrix(c(1, 0, 0, 1), mrow=2, byrow=TRUE)}
}
\value{
Returns the cluster assignments after the last iteration.
Examples
cluster_datapoints(generate_split_data(350, 0.5)$x, sigma0=diag(3^2, 2))
cluster_datapoints(petal, sigma0=petal_sigma0)
cluster_datapoints(width, sigma0=width_sigma0)
cluster_datapoints(mixed, sigma0=mixed_sigma0)
}
\description{
Gibbs sampling for the Chinese Restaurant Process
Implementation details can be found in the associated paper
The algorithm stops at every 1000th iteration and prints
the current cluster configuration.
}
