% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribute_sim_ind.R
\name{attribute_sim_ind}
\alias{attribute_sim_ind}
\title{Simulate the Attributes with the Assumption of Independent Attributes}
\usage{
attribute_sim_ind(
  product_shapes_and_levels,
  attributes_number,
  shape_attributes_number,
  level_attributes_number
)
}
\arguments{
\item{product_shapes_and_levels}{A numeric dateframe of three columns: product_id, assigned_shape and assigned_level}

\item{attributes_number}{The number of attributes}

\item{shape_attributes_number}{The number of attributes assigned to shape}

\item{level_attributes_number}{The number of attributes assigned to level}
}
\value{
A numeric dateframe of the following columns: product_id, assigned_shape, assigned_level and attributes (as columns)
}
\description{
Simulate the attributes for each product with the assumption
that the attributes of shapes are independent of the attributes of levels.
We mean by independence the fact that each attribute is related to one of
the following: shape, level or nothing.
}
\examples{
attribute_sim_ind(product_shapes_and_levels=
data.frame(product_id=1:4,assigned_shape=c(1,1,2,2),
assigned_level=c(5,3,3,3)),
attributes_number=15,
shape_attributes_number=7,
level_attributes_number=4)

}
