% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_accr.R
\name{daccr}
\alias{daccr}
\alias{paccr}
\alias{qaccr}
\alias{raccr}
\title{Accrual}
\usage{
daccr(x, arm)

paccr(q, arm, lower.tail = T)

qaccr(p, arm)

raccr(n = 1, arm)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{arm}{object of class 'arm'.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P(X \le x)};
otherwise, \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{daccr} gives the density, \code{paccr} gives the distribution
  function, \code{qaccr} gives the quantile function, and \code{raccr} generates
  random deviates.
}
\description{
Density, distribution function, quantile function,
and random generation for the accrual distribution.
}
\seealso{
\code{\link{create_arm}} and \code{\link{create_arm_lachin}}
  for creating an object of class 'arm'.
}
