% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_dep_multi_norm_poly.R
\name{cov_dep_multi_norm_poly}
\alias{cov_dep_multi_norm_poly}
\title{Simulate covariate-dependent multiscale sup-norm for use in NSP, for piecewise-polynomial models}
\usage{
cov_dep_multi_norm_poly(n, deg, N = 10000)
}
\arguments{
\item{n}{The data length (for which the multiscale norm is to be simulated)}

\item{deg}{The degree of the polynomial model (0 for the piecewise-constant model; 1 for piecewise-linearity, etc.).}

\item{N}{Desired number of simulated values of the norm.}
}
\value{
Sample of size \code{N} containing the simulated norms.
}
\description{
This function simulates the multiscale sup-norm adjusted for the form of the covariates, as described in Section 5.3
of the paper, for piecewise-polynomial models of degree \code{deg}. This is done for i.i.d. N(0,1) innovations.
}
\details{
The NSP algorithm is described in P. Fryzlewicz (2021) "Narrowest Significance Pursuit: inference for multiple change-points in linear
models", preprint.
}
\examples{
set.seed(1)
g <- c(rep(0, 100), rep(2, 100))
x.g <- g + stats::rnorm(200)
mscale.norm.200 <- cov_dep_multi_norm_poly(200, 0, 100)
nsp_poly(x.g, 100, thresh.val = stats::quantile(mscale.norm.200, .95))
}
\seealso{
\code{\link{cov_dep_multi_norm}}, \code{\link{sim_max_holder}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
