% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_max_holder.R
\name{sim_max_holder}
\alias{sim_max_holder}
\title{Simulate Holder-like norm of the Wiener process for use in self-normalised NSP}
\usage{
sim_max_holder(n, N, eps, c = exp(1 + 2 * eps))
}
\arguments{
\item{n}{Number of equispaced sampling points for the Wiener process on \code{[0,1]}.}

\item{N}{Desired number of simulated values of the norm.}

\item{eps}{Parameter of the self-normalisation statistic as described in the paper.}

\item{c}{Parameter of the self-normalisation statistic as described in the paper; use default if unsure how to set.}
}
\value{
Sample of size \code{N} containing the simulated norms.
}
\description{
This function simulates a sample of size \code{N} of values of the Holder-like norm of the Wiener process discretised with step 1/\code{n}.
The sample can then be used to find a suitable threshold for use with the self-normalised NSP.
}
\details{
The NSP algorithm is described in P. Fryzlewicz (2021) "Narrowest Significance Pursuit: inference for multiple change-points in linear
models", preprint.
}
\examples{
set.seed(1)
g <- c(rep(0, 100), rep(10, 100), rep(0, 100))
x.g <- g + stats::rnorm(300) * seq(from = 1, to = 4, length = 300)
wn003 <- sim_max_holder(100, 500, .03)
lambda <- as.numeric(stats::quantile(wn003, .9))
nsp_poly_selfnorm(x.g, M = 100, thresh.val = lambda)
}
\seealso{
\code{\link{nsp_selfnorm}}, \code{\link{nsp_poly_selfnorm}}, \code{\link{cov_dep_multi_norm}}, \code{\link{cov_dep_multi_norm_poly}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
