% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npnorm.R
\name{npnorm}
\alias{npnorm}
\alias{rnpnorm}
\alias{dnpnorm}
\alias{pnpnorm}
\title{Class \code{npnorm}}
\usage{
npnorm(v, w = 1)
rnpnorm(n, mix=disc(0), sd=1)
dnpnorm(x, mix=disc(0), sd=1, log=FALSE)
pnpnorm(x, mix=disc(0), sd=1, lower.tail=TRUE, log.p=FALSE)
}
\arguments{
\item{v}{a numeric vector that stores the values of a sample.}

\item{w}{a numeric vector that stores the corresponding
weights/frequencies of the observations.}

\item{n}{the sample size.}

\item{mix}{an object of class \code{disc}, for a discrete
distribution.}

\item{sd}{a scalar for the component standard deviation that is
common to all components.}

\item{x}{a numeric vector or an object of class \code{npnorm}.}

\item{log, log.p}{logical, for computing the log-values or not.}

\item{lower.tail}{logical, for computing the lower tail value or
not.}
}
\description{
Class \code{npnorm} can be used to store data that
  will be processed as those of a nonparametric normal
  mixture. There are several functions associated with the class.

 Function \code{npnorm} creates an object of class \code{npnorm},
 given values and weights/frequencies.

 Function \code{rnpnorm} generates a random sample from a normal
 mixture and saves the data as an object of class \code{npnorm}.

 Function \code{dnpnorm} is the density function of a normal
 mixture.

 Function \code{pnpnorm} is the distribution function of a normal
 mixture.
}
\examples{

mix = disc(pt=c(0,4), pr=c(0.3,0.7))  # a discrete distribution
x = rnpnorm(200, mix, sd=1)
dnpnorm(-2:6, mix, sd=1)
pnpnorm(-2:6, mix, sd=1)
dnpnorm(npnorm(-2:6), mix, sd=1)
pnpnorm(npnorm(-2:6), mix, sd=1)

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
