% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchLabels.R
\name{getMatchLabels}
\alias{getMatchLabels}
\title{Gets labels of annotations on a given layer, identified by given match IDs}
\usage{
getMatchLabels(
  labbcat.url,
  match.ids,
  layer.ids,
  target.offset = 0,
  annotations.per.layer = 1,
  include.match.ids = FALSE,
  page.length = 1000,
  no.progress = FALSE
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{match.ids}{A vector of annotation IDs, e.g. the MatchId column, or the URL column,
of a results set.}

\item{layer.ids}{A vector of layer IDs.}

\item{target.offset}{The distance from the original target of the match, e.g.
\itemize{
\item \emph{0} -- find annotations of the match target itself
\item \emph{1} -- find annotations of the token immediately \emph{after} match target
\item \emph{-1} -- find annotations of the token immediately \emph{before} match target
}}

\item{annotations.per.layer}{The number of annotations on the given layer to
retrieve. In most cases, there's only one annotation available. However, tokens
may, for example, be annotated with `all possible phonemic transcriptions', in which
case using a value of greater than 1 for this parameter provides other phonemic
transcriptions, for tokens that have more than one.}

\item{include.match.ids}{Whether or not the data frame returned includes the original
MatchId column or not.}

\item{page.length}{In order to prevent timeouts when there are a large number of
matches or the network connection is slow, rather than retrieving matches in one
big request, they are retrieved using many smaller requests. This parameter
controls the number of results retrieved per request.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
A data frame of labels.
}
\description{
Gets labels of annotations on a given layer, identified by given match IDs
}
\examples{
\dontrun{
## Perform a search
results <- getMatches(labbcat.url, list(orthography="quake"))

## Get the topic annotations for the matches
topics <- getMatchLabels(labbcat.url, results$MatchId, "topic")
}

}
\seealso{
\itemize{
\item \link{getMatches}
\item \link{getMatchAlignments}
}
}
\keyword{annotation}
\keyword{label}
\keyword{layer}
