% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/legendFunctions.R
\name{prepLegend}
\alias{prepLegend}
\title{Function for arranging plotting layout to accomodate a legend panel}
\usage{
prepLegend(layout = c(1, 1), type = if (is.matrix(layout)) "layout" else
  "mfrow", side = "right", proportion = 0.15, heights = NULL,
  widths = NULL)
}
\arguments{
\item{layout}{layout vector or matrix}

\item{type}{type of layout; either "mfrow" or "layout"}

\item{side}{side of the plot to place legend on; one of "top", "bottom", "left" or "right"}

\item{proportion}{proportion of plotting window to allocate to legend}

\item{heights}{height vector for original layout (before the legend panel is appended)}

\item{widths}{width vector for original layout (before the legend panel is appended)}
}
\value{
none; layout is passed to current device
}
\description{
Function for arranging plotting layout to accomodate a legend panel
}
\examples{
layout <- c(2,3);
side <- "left"
proportion <- 0.2

prepLegend(layout = layout, side = side, proportion = proportion)
for(i in 1:(layout[1]*layout[2]))
	plot(1:7, 1:7, col = 1:7, pch = 19, cex = 2.2, xaxt = "n",
			yaxt = "n", ann = FALSE)
addLegend(legend = paste("Group", 1:7), font = 2,
		pch = 19, pt.cex = 2, text.col = 1:7, col = 1:7,
		y.intersp = 1.5, cex = 1.5)


layout = rbind(c(1, 2, 3), c(0, 4, 3), c(0, 4, 5))
side = "right"
proportion = 0.15

prepLegend(layout = layout, side = side, proportion = proportion)
for(i in 1:max(layout))
	plot(1:7, 1:7, col = 1:7, pch = 19, cex = 2.2, xaxt = "n",
			yaxt = "n", xlab = "", ylab = "", main = paste("Plot", i))
addLegend(legend = paste("Group", 1:7), font = 2,
		pch = 19, pt.cex = 2, text.col = 1:7, col = 1:7,
		y.intersp = 1.5, cex = 1.5)
}
\author{
Jason Waddell
}

