% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\name{plot,sealevel-method}
\alias{plot,sealevel-method}
\alias{plot.sealevel}
\title{Plot a sealevel Object}
\usage{
\S4method{plot}{sealevel}(
  x,
  which = 1:3,
  drawTimeRange = getOption("oceDrawTimeRange"),
  mgp = getOption("oceMgp"),
  mar = c(mgp[1] + 0.5, mgp[1] + 1.5, mgp[2] + 1, mgp[2] + 3/4),
  marginsAsImage = FALSE,
  grid = TRUE,
  xlim,
  ylim,
  xaxs = "i",
  yaxs = "r",
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{x}{a \linkS4class{sealevel} object.}

\item{which}{a numerical or string vector indicating desired plot types,
with possibilities 1 or \code{"all"} for a time-series of all the elevations, 2 or
\code{"month"} for a time-series of just the first month, 3 or
\code{"spectrum"} for a power spectrum (truncated to frequencies below 0.1
cycles per hour, or 4 or \code{"cumulativespectrum"} for a cumulative
integral of the power spectrum.}

\item{drawTimeRange}{boolean that applies to panels with time as the
horizontal axis, indicating whether to draw the time range in the top-left
margin of the plot.}

\item{mgp}{3-element numerical vector to use for \code{\link{par}}\code{("mgp")}, and also
for \code{\link{par}}\code{("mar")}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}}\code{("mar")}.}

\item{marginsAsImage}{logical value indicating whether to put a
wide margin to the right of time-series plots, matching the space
used up by a palette in an \code{\link[=imagep]{imagep()}} plot.}

\item{grid}{logical value, indicating whether to draw a grid with
\code{\link[=grid]{grid()}}.}

\item{xlim, ylim}{optional limits for axes. If not supplied,
reasonable choices will be made}

\item{xaxs, yaxs}{axis-limit parameters, as for standard graphics.
The default is to make the time axis extend to the edges of
the box, but to make the y axis have some space above and below
the range of the data.}

\item{debug}{a flag that turns on debugging, if it exceeds 0.}

\item{\dots}{optional arguments passed to plotting functions.}
}
\value{
None.
}
\description{
Creates a plot for a sea-level dataset, in one of two varieties.  Depending
on the length of \code{which}, either a single-panel or multi-panel plot is
drawn.  If there is just one panel, then the value of \code{par} used in
\verb{plot,sealevel-method} is retained upon exit, making it convenient to add to
the plot.  For multi-panel plots, \code{par} is returned to the value it had
before the call.
}
\section{Historical Note}{

Until 2020-02-06, sea-level plots had the mean value removed, and indicated
with a tick mark and margin note on the right-hand side of the plot.
This behaviour was confusing. The change did not go through the usual
deprecation process, because the margin-note behaviour had not
been documented.
}

\examples{
library(oce)
data(sealevel)
# local Halifax time is UTC + 4h
juan <- as.POSIXct("2003-09-29 00:15:00", tz = "UTC") + 4 * 3600
plot(sealevel, which = 1, xlim = juan + 86400 * c(-7, 7))
abline(v = juan, col = "red")

}
\references{
The example refers to Hurricane Juan, which caused a great deal
of damage to Halifax in 2003.  Since this was in the era of the digital
photo, a casual web search will uncover some spectacular images of damage,
from both wind and storm surge.
Landfall, within 30km of this sealevel
gauge, was between 00:10 and 00:20 Halifax local time on Monday, Sept 29,
2003.
}
\seealso{
The documentation for the \linkS4class{sealevel} class explains the
structure of sealevel objects, and also outlines the other functions dealing
with them.

Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to sealevel data: 
\code{\link{[[,sealevel-method}},
\code{\link{[[<-,sealevel-method}},
\code{\link{as.sealevel}()},
\code{\link{read.sealevel}()},
\code{\link{sealevel}},
\code{\link{sealevel-class}},
\code{\link{sealevelTuktoyaktuk}},
\code{\link{subset,sealevel-method}},
\code{\link{summary,sealevel-method}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to sealevel data}
