% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{read.xbt}
\alias{read.xbt}
\title{Read an xbt file}
\usage{
read.xbt(
  file,
  type = "sippican",
  longitude = NA,
  latitude = NA,
  encoding = "latin1",
  debug = getOption("oceDebug"),
  processingLog
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{type}{character string indicating type of file, with valid choices being
\code{"sippican"} and \code{"noaa1"}.}

\item{longitude, latitude}{optional signed numbers indicating the longitude in degrees
East and latitude in degrees North. These values are used if \code{type="sippican"},
but ignored if \code{type="noaa1"}, because those files contain location information.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{debug}{a flag that turns on debugging.  The value indicates the depth
within the call stack to which debugging applies.}

\item{processingLog}{if provided, the action item to be stored in the log.  This
parameter is typically only provided for internal calls; the default that it
provides is better for normal calls by a user.}
}
\value{
An \linkS4class{xbt} object.
}
\description{
Two file types are handled: (1) the \code{"sippican"} format, used
for Sippican XBT files, handled with \code{\link[=read.xbt.edf]{read.xbt.edf()}}, and (2)
the \code{"noaa1"} format, handled with \code{\link[=read.xbt.noaa1]{read.xbt.noaa1()}}. The first of
these is recognized by \code{\link[=read.oce]{read.oce()}}, but the second must be called
directly with \code{\link[=read.xbt.noaa1]{read.xbt.noaa1()}}.
}
\examples{
library(oce)
xbt <- read.oce(system.file("extdata", "xbt.edf", package = "oce"))
summary(xbt)
plot(xbt)

}
\references{
\enumerate{
\item Sippican, Inc. "Bathythermograph Data Acquisition System: Installation, Operation and Maintenance
Manual (P/N 308195, Rev. A)," 2003.
https://pages.uoregon.edu/drt/MGL0910_Science_Report/attachments/MK21_ISA_Manual_Rev_A.pdf.
}
}
\seealso{
Other things related to xbt data: 
\code{\link{[[,xbt-method}},
\code{\link{[[<-,xbt-method}},
\code{\link{as.xbt}()},
\code{\link{plot,xbt-method}},
\code{\link{read.xbt.noaa1}()},
\code{\link{subset,xbt-method}},
\code{\link{summary,xbt-method}},
\code{\link{xbt}},
\code{\link{xbt-class}},
\code{\link{xbt.edf}}
}
\author{
Dan Kelley
}
\concept{things related to xbt data}
