% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_module.R
\name{table_ui}
\alias{table_ui}
\alias{table_server}
\title{NOAA table module}
\usage{
table_ui(id, download = NULL)

table_server(id, NOAA, variable)
}
\arguments{
\item{id}{Namespace id shiny module.}

\item{download}{Add download button.}

\item{NOAA}{Reactive value for the dataset containing the locations
coordinates.}

\item{variable}{Reactivevalues for selected variable information.}
}
\value{
Shiny module.
}
\description{
This shiny module (\code{table_ui()} + \code{table_server()}) visualizes the loaded
and filtered data in a table format.
}
\examples{

if (interactive()) {
# run table module stand-alone

library(oceanexplorer)
library(shiny)

# data
NOAA <- get_NOAA("oxygen", 1, "annual")

# coordinates
points <- filter_NOAA(NOAA, 1, list(lon = c(-160, -120), lat =  c(11, 12)))

# gui
ui <- fluidPage(table_ui("table"))

# server
server <-function(input, output, session) {
 # table
 output_table <- table_server(
  "table",
  reactive(points),
  reactiveValues(parm = "temperature", spat = 1, temp = "annual")
  )
}

# run app
shinyApp(ui, server)

}

}
