% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geosecs235.R
\docType{data}
\name{geosecs235}
\alias{geosecs235}
\title{GEOSECS station 235 data}
\usage{
data(geosecs235, package="ocedata")
}
\description{
\code{geosecs235} is station 235 of the GEOSECS mission, with data downloaded
from Reference 1, and referred to in Kelley and Van Scoy (1999).
}
\examples{
data(geosecs235, package="ocedata")
\dontrun{
# Create a plot similar to Figure 10 of Kelley and Van Scoy (1999)
oce::plotProfile(geosecs235, xtype="tritium", type='p', ylim=c(600, 0))
}

}
\references{
\enumerate{
\item \code{https://iridl.ldeo.columbia.edu/SOURCES/.GEOSECS/ISTA/235/VALUE/}
\item D. E. Kelley and Van Scoy, K. A., 1999.  A basin-wide estimate of
vertical mixing in the upper pycnocline: spreading of bomb tritium in the
North Pacific Ocean.  \emph{Journal of Physical Oceanography},
29:1759--1771.
}
}
