% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{odmatrix_to_od}
\alias{odmatrix_to_od}
\title{Convert origin-destination data from wide to long format}
\usage{
odmatrix_to_od(odmatrix)
}
\arguments{
\item{odmatrix}{A matrix with row and columns representing origin and destination zone codes
and cells representing the flow between these zones.}
}
\description{
This function takes a matrix representing travel between origins
(with origin codes in the \code{rownames} of the matrix)
and destinations
(with destination codes in the \code{colnames} of the matrix)
and returns a data frame representing origin-destination pairs.
}
\details{
The function returns a data frame with rows ordered by origin and then destination
zone code values and with names \code{orig}, \code{dest} and \code{flow}.
}
\examples{
x = od_data_df
x[1:3]
odmatrix = od_to_odmatrix(od_data_df)
odmatrix
odmatrix_to_od(odmatrix)
}
\seealso{
Other od: 
\code{\link{od_id}},
\code{\link{od_to_odmatrix}()}
}
\concept{od}
