% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot.r
\name{forest_plot}
\alias{forest_plot}
\title{Forest plot}
\usage{
forest_plot(coef, se, sort = TRUE, exp = FALSE)
}
\arguments{
\item{coef}{a matrix contains the GxE effect sizes. Each row corresponds to
a SNP in a set, and each column represents a study. If the matrix has
colnames and/or rownames for SNPs and studies respectively, they will be
used as labels in the forest plot.}

\item{se}{a matrix contains the standard errors for the GxE effect
estimates. Each row corresponds to a SNP in a set, and each column
represents a study.}

\item{sort}{logical. If TRUE, the SNPs are sorted by averaged effect sizes
across different studies. The default is TRUE.}

\item{exp}{logical. If TRUE, coef will be exponentiated. This option is
mainly used for log odds ratios obtained from logistic regressions. The
default is FALSE.}
}
\value{
A forest plot across multiple sub-studies for all the SNPs in a set
(e.g., a gene).
}
\description{
It makes a forest plot for gene-environment interactions (GxE) across
multiple sub-studies for all the SNPs in a set (e.g., a gene).
}
\examples{


coef = matrix(rnorm(6 * 6), 6, 6)
se = matrix(abs(runif(6 * 6, 0.1, 0.15)), 6, 6)

forest_plot(coef, se)

}
