% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ohsome_get_metadata.R
\name{ohsome_get_metadata}
\alias{ohsome_get_metadata}
\title{GET metadata from ohsome API}
\usage{
ohsome_get_metadata(quiet = FALSE)
}
\arguments{
\item{quiet}{logical; suppresses message on data attribution, API version and
temporal extent.}
}
\value{
An \code{ohsome_metadata} object. This is a named list with the
attributes \code{date}, \code{status_code} (of the GET request) and the following list
elements:
\itemize{
\item \code{attribution}: character; \code{url} and \code{text} of OSM data copyrights and
attribution
\item \code{apiVersion}: character; Version of the ohsome API
\item \code{timeout}: numeric; limit of the processing time in seconds
\item \code{extractRegion}:
\itemize{
\item \code{spatialExtent}: sfc_POLYGON; spatial boundary of the OSM data in the
underlying OSHDB
\item \code{temporalExtent}: vector of ISO 8601 character; start and end of the temporal extent of OSM data in the
underlying OSHDB
\item \code{replicationSequenceNumber}: numeric; precise state of the OSM data
contained in the underlying OSHDB, expressed as the id of the last
applied (hourly) diff file from \href{https://planet.openstreetmap.org}{Planet OSM}
}
}
}
\description{
Returns parsed metadata from ohsome API
}
\details{
\code{ohsome_get_metadata()} sends a GET request to the metadata endpoint of
ohsome API and parses the response. The parsed metadata is silently returned.
}
\examples{
\dontrun{
ohsome_get_metadata()
}
}
\seealso{
\href{https://docs.ohsome.org/ohsome-api/v1/endpoints.html#metadata}{ohsome API Endpoints -- Metadata}
}
