% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim_scale.R
\name{anim_scale}
\alias{anim_scale}
\title{Animate an element through scaling}
\usage{
anim_scale(scale = NULL, easing_fn = NULL)
}
\arguments{
\item{scale}{The scale value of the element at the keyframe time (given as
the LHS value in the \code{\link[=anims]{anims()}} call). If providing a single scaling value,
the scaling will operate in the x and y directions (relative to the center
of the element). If two values are provided, these will be taken as scaling
values in the x and y directions.}

\item{easing_fn}{The timing or easing function to use for the animation. If
not provided, the \code{\link[=linear]{linear()}} timing function will be used (which is doesn't
use any easing in the animation, just a linear movement). The other timing
and easing functions are: \code{\link[=step_start]{step_start()}}, \code{\link[=step_end]{step_end()}}, \code{\link[=ease_in]{ease_in()}},
\code{\link[=ease_out]{ease_out()}}, and \code{\link[=ease_in_out]{ease_in_out()}}.}
}
\value{
An \code{anim_opacity} object, which is to be used as part of an \code{\link[=anims]{anims()}}
call.
}
\description{
Within an \code{\link[=anims]{anims()}} call, itself passed to any \code{anims} argument, the
\code{anim_scale()} function can be used to express an animation where the target
element undergoes a scaling change with time.
}
\examples{
if (interactive()) {

# Basic animation of an element's
# scaling state (moving to a new
# `scale` value)
SVG(width = 300, height = 300) \%>\%
  svg_rect(
    x = 50, y = 50,
    width = 50, height = 50,
    attrs = svg_attrs_pres(
      stroke = "magenta",
      fill = "lightblue"
    ),
    anims = anims(
      2.0 ~ anim_scale(scale = 2)
    )
  )
}

}
