% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_ellipse}
\alias{svg_ellipse}
\title{Addition of an \code{ellipse} element}
\usage{
svg_ellipse(
  svg,
  x,
  y,
  width,
  height,
  stroke = NULL,
  stroke_width = NULL,
  fill = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{x, y}{The \code{x} and \code{y} positions of the center of the ellipse to be
drawn. The \code{x} and \code{y} values are relative to upper left of the SVG drawing
area.}

\item{width, height}{The \code{width} and \code{height} of the ellipse that is to be
drawn. The \code{width} is the overall width of the ellipse in the 'x'
direction, centered on point \code{x}. The \code{height} is the distance in the 'y'
direction, centered on point \code{y}.}

\item{stroke}{The color of the stroke applied to the element (i.e., the
outline).}

\item{stroke_width}{The width of the stroke in units of pixels.}

\item{fill}{The fill color of the element.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_ellipse()} function adds an ellipse to an \code{svg} object. The position
of the ellipse is given by \code{x} and \code{y}, and they refer to the center point of
the point of the ellipse. The \code{width} and the \code{height}, both in units of
\code{px}, provide the horizontal and vertical extents of the ellipse.
}
\examples{
if (interactive()) {

# Create an SVG with a single
# ellipse element
svg <-
  SVG(width = 60, height = 60) \%>\%
    svg_ellipse(
      x = 30, y = 30,
      width = 50, height = 30,
      fill = "purple"
    )
}

}
