% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_image}
\alias{svg_image}
\title{Addition of an \code{image} element}
\usage{
svg_image(
  svg,
  x,
  y,
  image,
  width = NULL,
  height = NULL,
  preserve_aspect_ratio = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{x, y}{The \code{x} and \code{y} positions of the upper left of the image to be
included. The \code{x} and \code{y} values are relative to upper left of the SVG
drawing area itself.}

\item{image}{The URL for the image file.}

\item{width, height}{The width and height of the rectangle in which the image
will be placed. If both are not provided, the image's original dimensions
will be used. If one of these is provided, then the image will be scaled to
the provided value with the aspect ratio intact. Providing both will result
in the image placed in center of the rectangle with the aspect ratio
preserved.}

\item{preserve_aspect_ratio}{Controls how the aspect ratio of the image is
preserved. Use \code{"none"} if the image's original aspect ratio should not be
respected; this will fill the rectangle defined by \code{width} and \code{height}
with the image (and this is only if both values are provided).}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_image()} function adds an image to an \code{svg} object. The starting
position is defined by \code{x} and \code{y} values. The image \code{width} and \code{height} are
also required. All of these attributes are expressed in units of \code{px}.
}
\examples{
if (interactive()) {

# Create an SVG with an SVG image
# (the R logo) contained within it
svg <-
  SVG(width = 300, height = 300) \%>\%
    svg_image(
      x = 20, y = 20,
      width = 100,
      height = 100,
      image = "https://www.r-project.org/logo/Rlogo.svg"
    )
}

}
