% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rmse}
\alias{rmse}
\title{Computes the RMSE score.}
\usage{
rmse(x)
}
\arguments{
\item{x}{a numerical vector of residuals.}
}
\value{
The RMSE score.
}
\description{
Returns the RMSE.
}
\details{
Used for forecast evaluation evaluation and optimization of parameters in model fitting.

Note that \code{NA}s are ignored (i.e. \code{mean} is called with \code{na.rm=TRUE}).
}
\examples{


 # Just a vector to be forecasted
 y <- c(filter(rnorm(100), 0.95, "recursive"))
 # Generate a forecast matrix with a simple persistence model
 Yhat <- persistence(y, kseq=1:4)
 # The residuals for each horizon
 Resid <- residuals(Yhat, y)

# Calculate the score for the k1 horizon
rmse(Resid$h1)

# For all horizons
apply(Resid, 2, rmse)


}
\seealso{
\code{\link{score}()} for calculation of a score for the k'th horizon
}
