% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_functions.R
\name{color.bar}
\alias{color.bar}
\title{Color bar}
\usage{
color.bar(
  pal,
  min,
  max = -min,
  nticks = 11,
  ticks = seq(min, max, len = nticks),
  title = ""
)
}
\arguments{
\item{pal}{character. A vector with color IDs.}

\item{min}{numeric. Value for lower limit of the scale.}

\item{max}{numeric. Value for upper limit of the scale.}

\item{nticks}{integer. Number of subdivisions of the scale.}

\item{ticks}{integer. A vector of values for the scale.}

\item{title}{character. A legend for the scale bar.}
}
\value{
A plot of the color scale bar.
}
\description{
Function to plot the color scale bar.
}
\examples{
stat <- runif(10, 0.25, 1)
hm.palette <- colorRampPalette(RColorBrewer::brewer.pal(9, "Spectral"), space = "Lab")
color.bar(hm.palette(100), min = min(stat), max = max(stat),
          ticks = round(c(min(stat), max(stat)/2, max(stat)), 2), title = "")

}
\author{
Sergei Tarasov
}
