% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_timeseries.R
\name{plot_TS}
\alias{plot_TS}
\alias{plot_SSB}
\alias{plot_Biomass}
\alias{plot_Landings}
\alias{plot_Removals}
\alias{plot_Recruits}
\alias{plot_F}
\alias{plot_LifeHistory}
\title{Plots the median and quantiles of a time-series}
\usage{
plot_TS(
  x,
  xlab = "Year",
  ylab = "Spawning Biomass",
  title = "",
  quantiles = c(0.025, 0.975),
  scale = NULL,
  alpha = 0.1,
  lwd = 1,
  use_theme = NULL,
  colpalette = "Dark2",
  facet = TRUE,
  inc.Legend = !facet,
  inc.Hist = FALSE,
  print = TRUE,
  get_function = get_SSB,
  years = NULL,
  ...
)

plot_SSB(x, ...)

plot_Biomass(x, ylab = "Biomass", ...)

plot_Landings(x, ylab = "Landings", ...)

plot_Removals(x, ylab = "Removals", ...)

plot_Recruits(x, ylab = "Recruits", ...)

plot_F(x, ylab = "Fishing Mortality (F)", ...)

plot_LifeHistory(
  x,
  xlab = "Year",
  ylab = "Median (quantiles)",
  title = "",
  quantiles = c(0.025, 0.975),
  scale = NULL,
  alpha = 0.1,
  lwd = 1,
  use_theme = NULL,
  colpalette = "Dark2",
  facet = TRUE,
  inc.Legend = !facet,
  inc.Hist = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{An object of class \code{Hist}, \code{MSE}, or a list of \code{Hist} or \code{MSE} objects}

\item{xlab}{X-axis label (default 'Year')}

\item{ylab}{Y-axes label}

\item{title}{Optional title}

\item{quantiles}{Lower and upper quantiles to calculate. Numeric vector of length 2.}

\item{scale}{An optional function with a single numeric argument that returns transformed or scaled numeric values. See \code{lb2kg} and \code{kg2lb} for example.
Can be a list of functions for list objects (NA for no transformation)}

\item{alpha}{Transparency parameter}

\item{lwd}{Line width}

\item{use_theme}{Optional ggplot theme}

\item{colpalette}{Color palette from \code{RColorBrewer}}

\item{facet}{Logical. Facet the plot?}

\item{inc.Legend}{Logical. Include legend?}

\item{inc.Hist}{Logical. For \code{MSE} results, include the historical period?}

\item{print}{Logical. Print the plot?}

\item{get_function}{\code{get_} function to extract time-series information from \code{x}}

\item{years}{Optional numeric vector specifying the years to plot. Default is all years.}

\item{...}{Named arguments passed to \code{plot_TS}}
}
\value{
A named list with:\tabular{ll}{
\code{p} \tab The \code{ggplot} object \cr
\code{df} \tab Data.frame with the summary statistics (median and quantiles) \cr
}
}
\description{
Plots the median and quantiles of a time-series
}
\section{Functions}{
\itemize{
\item \code{plot_SSB()}: Plot the Spawning Biomass

\item \code{plot_Biomass()}: Plot the Total Biomass

\item \code{plot_Landings()}: Plot the Landings (biomass)

\item \code{plot_Removals()}: Plot the Removals (biomass)

\item \code{plot_Recruits()}: Plot the Recruits (numbers)

\item \code{plot_F()}: Plot the Recruits (numbers)

\item \code{plot_LifeHistory()}: Plot the Life-History parameters

}}
