% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_at_Age.R
\name{plot_at_Age}
\alias{plot_at_Age}
\alias{plot_Length}
\alias{plot_Weight}
\alias{plot_Maturity}
\alias{plot_N.Mortality}
\alias{plot_Select}
\alias{plot_Retention}
\alias{plot_Select_Maturity}
\title{Plot at-Age schedules}
\usage{
plot_at_Age(
  x,
  quantiles = c(0.025, 0.975),
  scale = NULL,
  variable = "Length",
  xlab = "Age (Year)",
  ylab = NULL,
  title = "",
  years = NULL,
  alpha = 0.1,
  lwd = 1,
  use_theme = NULL,
  colpalette = "Dark2",
  print = TRUE
)

plot_Length(x, ...)

plot_Weight(x, ...)

plot_Maturity(x, ...)

plot_N.Mortality(x, ...)

plot_Select(x, ...)

plot_Retention(x, ...)

plot_Select_Maturity(x, ...)
}
\arguments{
\item{x}{An object of class \code{Hist}, \code{MSE}, or a list of \code{Hist} or \code{MSE} objects}

\item{quantiles}{Lower and upper quantiles to calculate. Numeric vector of length 2.}

\item{scale}{An optional function with a single numeric argument that returns transformed or scaled numeric values. See \code{lb2kg} and \code{kg2lb} for example.
Can be a list of functions for list objects (NA for no transformation)}

\item{variable}{String. One of 'Length', 'Weight', 'N.Mortality','Maturity', 'Select', 'Retention'}

\item{xlab}{X-axis label (default 'Age (Year)')}

\item{ylab}{Y-axes label}

\item{title}{Optional title}

\item{years}{Optional numeric vector specifying the years to plot. Default is the first and last historical year, and the last projection year}

\item{alpha}{Transparency parameter}

\item{lwd}{Line width}

\item{use_theme}{Optional ggplot theme}

\item{colpalette}{Color palette from \code{RColorBrewer}}

\item{print}{Logical. Print the plot?}

\item{...}{Named arguments passed to \code{plot_at_Age}}
}
\value{
A named list with:\tabular{ll}{
\code{p} \tab The \code{ggplot} object \cr
\code{df} \tab Data.frame with the summary statistics (median and quantiles) \cr
}
}
\description{
Plots Length, Weight, Maturity, Natural-Mortality, Selectivity, and Retention-at-Age
schedules.
}
\details{
Note that the Selectivity and Retention curves in these plots are from the operating model. If an MP changes the
selectivity/retention, this is not shown in these plots.
}
\section{Functions}{
\itemize{
\item \code{plot_Length()}: Plot Length-at-Age

\item \code{plot_Weight()}: Plot Weight-at-Age

\item \code{plot_Maturity()}: Plot Maturity-at-Age

\item \code{plot_N.Mortality()}: Plot N.Mortality-at-Age

\item \code{plot_Select()}: Plot Selectivity-at-Age

\item \code{plot_Retention()}: Plot Retention -at-Age

\item \code{plot_Select_Maturity()}: Plot Selectivity-, Retention-, and Maturity-at-Age

}}
