#' life_exp
#'
#' A data frame with 3142 rows and 4 columns. County level data for life expectancy and median income in the United States.
#'
#'
#' @name life_exp
#' @docType data
#' @format A data frame with 3142 observations on the following 4 variables.
#' \describe{
#'   \item{state}{Name of the state.}
#'   \item{county}{Name of the county.}
#'   \item{expectancy}{Life expectancy in the county.}
#'   \item{income}{Median income in the county, measured in US $.}
#' }
#' @keywords datasets
#' @examples
#'
#' library(ggplot2)
#'
#' # Income V Expectancy
#' ggplot(life_exp, aes(x = income, y = expectancy)) +
#'   geom_point(color = openintro::IMSCOL["green", "full"], alpha = 0.2) +
#'   theme_minimal() +
#'   labs(
#'     title = "Is there a relationship between median income and life expectancy?",
#'     x = "Median income (US $)",
#'     y = "Life Expectancy (year)"
#'   )
"life_exp"
