% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassDiagOptThresh.R
\docType{class}
\name{diagOptThresh-class}
\alias{diagOptThresh-class}
\alias{diagOptThresh}
\title{An S4 class to describe the optimal threshold of a diagnostic marker.}
\description{
An S4 class to describe the optimal threshold of a diagnostic marker.
}
\details{
You never have to create this class manually. This class is created internally when the \code{diagThresh} function is used.
}
\section{Slots}{

\describe{
\item{\code{optThresh}}{This slot is an object that takes in argument the sampled optimal threshold values. Numeric argument.}

\item{\code{p}}{Prevalence specified by the user. Numeric argument.}

\item{\code{r}}{Risk threshold preference. Numeric argument.}

\item{\code{N}}{Sample size.}

\item{\code{xEvt}}{This slot is an object that takes in argument the marker values in the subgroup of patients that developed the event. Numeric argument.}

\item{\code{xNoEvt}}{This slot is an object that takes in argument the marker values in the subgroup of patients that did not develop the event. Numeric argument.}

\item{\code{lowEvt}}{This slot is a logical argument that specifies whether the low values of the marker are associated with the presence of the disease or not.}

\item{\code{mcmcChainEvt}}{This slot is an object that takes in argument the sampled distribution objects in the subgroup of patients that developed the event. list argument.}

\item{\code{mcmcChainNoEvt}}{This slot is an object that takes in argument the sampled distribution objects in the subgroup of patients that did not develop the event. list argument.}

\item{\code{tabMCMCChain}}{This slot is an object that takes in argument all the distribution parameters that were sampled using the MCMC algorithm. mcmc.listOrNull argument.}

\item{\code{paraNamesUserDefined}}{This slot is an object that takes in argument the list of the distribution parameter names defined by the user in a 'fitUserDefinedDist' object. list argument.}

\item{\code{cdfUserDefined}}{This slot is an object that takes in argument the list of cumulative distribution functions defined by the user in 'fitUserDefinedDist' objects. list argument.}

\item{\code{gradientUserDefined}}{This slot is an object that takes in argument the list of gradient functions defined by the user in 'fitUserDefinedDist' objects. list argument.}

\item{\code{hessianUserDefined}}{This slot is an object that takes in argument the list of hessian functions defined by the user in 'fitUserDefinedDist' objects. list argument.}

\item{\code{percentNA}}{This slot is a numeric object that indicates the percentage of NA values contained in the 'optThresh' slot.}
}}

\seealso{
\code{\link[optimalThreshold]{diagThresh}} for more details on how to estimate the optimal threshold of a diagnostic marker.
}
