% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudodata.R
\name{pseudodata}
\alias{pseudodata}
\title{Pseudodata for Likelihood-Based Continual Reassessment Method (CRM) Dose Finding Designs}
\usage{
pseudodata(design, dose10, dose90, percentagegradedose10 = c(45, 35, 10, 8,
  2), percentagegradedose90 = c(2, 3, 5, 40, 50), targetDLT = 0.3,
  stabilize = TRUE, discrete = FALSE, discretedoses = NA,
  rounddown = FALSE, combine01 = FALSE, plotit = TRUE)
}
\arguments{
\item{design}{Specifies which dose finding design you are running simulations on.
Choices are: POM, CR, or CRM.}

\item{dose10}{Hypothesized dose level for a 10 percent dose limiting toxicity (DLT) rate as specified
by clinical investigators prior to the start of the trial.}

\item{dose90}{Hypothesized dose level for a 90 percent dose limiting toxicity (DLT) rate as specified
by clinical investigators prior to the start of the trial.}

\item{percentagegradedose10}{Only applicable if using ordinal POM or CR model designs.
Expected percentage of toxicity grades at the specified dose10 in the form
c(percent grade 0, percent grade 1, grade 2, grade 3, grade 4) or
c(percent grades 0 and 1, grade 2, grade 3, grade 4) if combining grades 0 and 1 into one category.
The percentages must be specified between 0 and 100. If not specified,
it will default to c(45, 35, 10, 8, 2).}

\item{percentagegradedose90}{Only applicable if using ordinal POM or CR model designs.
Expected percentage of toxicity grades at the specified dose90. This is also in the form:
c(percent grade 0, percent grade 1, grade 2, grade 3, grade 4) or
c(percent grades 0 and 1, grade 2, grade 3, grade 4) if combining grades 0 and 1 into one category.
The percentages must be specified between 0 and 100. If not specified,
it will default to c(2, 3, 5, 40, 50).}

\item{targetDLT}{Target dose limiting toxicity (DLT) rate pre-specified by clinical investigators
prior to the start of the trial. Must be specified between 0 and 1.
Defaults to 0.30.}

\item{stabilize}{True/False. If stabilize = TRUE, expected dose levels for 30 percent
and 50 percent DLT rates will be estimated from the initialized CR model and these levels will be
added into the pseudodata to help stabilize the model. This is particularly helpful when
collected data is initially sparse at the beginning of a trial. Defaults to TRUE.}

\item{discrete}{True/False. If discrete = TRUE, this allows for discrete dose levels to be
specified prior to the start of the trial. Defaults to FALSE.}

\item{discretedoses}{Specified discrete dose levels if desired. They must be specified if discrete is equal to TRUE.
It is written for j dose levels as: c(d1, d2,..., dj).}

\item{rounddown}{True/False. Only applicable when using discrete dose levels.\cr
If rounddown = TRUE, the estimate dose from specified model will round down to the more conservative discrete dose level.\cr
If rounddown = FALSE, it will select the discrete dose closest to the estimated model selection. Defaults to FALSE.}

\item{combine01}{True/False. If combine01 = TRUE, toxicity grades 0 and 1 are combined into 1 category.
Therefore all toxicities must be coded: 0 (grades 0 and 1), 1 (grade2), 2 (grade 3),
and 3 (grade 4) according to CTCAEv4.0. Defaults to FALSE.}

\item{plotit}{True/False. If plotit = TRUE, returns a plot of the continuation ratio model estimated by
the pseudodata with the starting dose for a specified target DLT rate.
Also identifies dose10 and dose90 on the figure. Defaults to TRUE.}
}
\value{
\item{Pseudodata Toxicities}{A vector of toxicity grades as classified by CTCAEv4.0
created from the initialized model. If using a binary CRM this will be a vector of 0 (non-DLT) and
1 (DLT) outcomes. This will be the pseudodata toxicity grades used for the rest of trial.}

\item{Pseudodata Doses}{A vector of dose levels created from the initialized model.
This will be the pseudodata dose levels used for the rest of the trial.}

\item{Starting Dose}{The starting dose for this trial given the specified target DLT rate assuming
continuous dose levels.}

\item{Starting Discrete Dose}{The starting dose for this trial given the specified
target DLT rate assuming discrete dose levels.}

\item{Estimated Toxicity at Discrete Doses}{Only applicable if using specified discrete dose levels.
Returns the expected probability of
a dose-limiting toxicity (DLT) at each discrete dose level given the initialized model.}

\item{discretedoses}{Returns the possible ordered discrete doses if applicable.}

\item{Regression Model}{Returns parameter estimates for the newly estimated model.}
}
\description{
This function creates 2 pseudodata vectors (toxicity and dose levels) necessary to run any of the
3 variations of the likelihood-based CRM design. If using the ordinal POM or CR model design,
ordinal toxicity grades are specified by CTCAEv4.0. This function also specifies the starting dose
for a trial with the choice of continuous or discrete dose levels for a specified target dose limiting
toxicity (DLT) rate.
}
\details{
Fits a POM, CR model, or 2-parameter logistic model based on the dose where 10% and 90% DLTs are hypothesized to occur.
This outputs a vector of doses and toxicities to use as the starting model for this design (required to run
\code{\link{nextdose}} and \code{\link{crmsimulations}})
}
\examples{

######################
###For POM Model######
######################
#Creates pseudodata with no stabilization and continuous dose levels
pseudodata(design='POM', dose10 = 200, dose90 = 3600, targetDLT = 0.3,
           stabilize = TRUE, discrete = FALSE, discretedoses = NA,
           percentagegradedose10 = c(45, 35, 10, 8, 2),
           percentagegradedose90 = c(2, 3, 5, 40, 50), combine01 = FALSE)
#Creates pseudodata with stabilize=T and discrete dose levels
pseudodata(design='POM', dose10 = 500, dose90 = 2000, targetDLT = 0.3,
           stabilize = TRUE, discrete = TRUE,
           discretedoses = c(200, 500, 1000, 1200, 1500, 1800))
#Creates pseudodata when toxicity grades 0 and 1 are one category
pseudodata(design='POM', dose10 = 200, dose90 = 1000, targetDLT = 0.3,
           stabilize = TRUE, discrete = FALSE, discretedoses = NA,
           percentagegradedose10 = c(80, 10, 8, 2),
           percentagegradedose90 = c(5, 5, 40, 50), combine01 = TRUE)

######################
###For CR Model#######
######################
#Creates pseudodata with no stabilization and continuous dose levels
pseudodata(design='CR', dose10 = 200, dose90 = 3600, targetDLT = 0.3,
           stabilize = TRUE, discrete = FALSE, discretedoses = NA,
           percentagegradedose10 = c(45, 35, 10, 8, 2),
           percentagegradedose90 = c(2, 3, 5, 40, 50), combine01 = FALSE)
#Creates pseudodata with stabilize=T and discrete dose levels
pseudodata(design='CR', dose10 = 500, dose90 = 2000, targetDLT = 0.3,
           stabilize = TRUE, discrete = TRUE,
           discretedoses = c(200, 500, 1000, 1200, 1500, 1800))
#Creates pseudodata when toxicity grades 0 and 1 are one category
pseudodata(design='CR', dose10 = 200, dose90 = 1000, targetDLT = 0.3,
           stabilize = TRUE, discrete = FALSE, discretedoses = NA,
           percentagegradedose10 = c(80, 10, 8, 2),
           percentagegradedose90=c(5, 5, 40, 50), combine01 = TRUE)

######################
###For Binary CRM#####
######################
#Creates pseudodata with no stabilization and continuous dose levels
pseudodata(design='CRM', dose10 = 200, dose90 = 3600, targetDLT = 0.3,
           stabilize = TRUE, discrete = FALSE, discretedoses = NA)
#Creates pseudodata with stabilize=T and discrete dose levels
pseudodata(design='CRM', dose10 = 200, dose90 = 3000, targetDLT = 0.3,
           stabilize = TRUE, discrete = TRUE,
           discretedoses = c(200, 500, 1000, 1200, 1500, 1800))
}
\author{
Emily V. Dressler, PhD \cr
Markey Cancer Center \cr
Division of Cancer Biostatistics \cr
University of Kentucky \cr
\email{EmilyVDressler@gmail.com}
}
\references{
1. Van Meter EM, Garrett-Mayer E, Bandyopadhyay D. Proportional odds model for dose finding clinical trial designs with ordinal toxicity grading. Statistics in Medicine 2011; 30: 2070-2080. \cr
2. Van Meter EM, Garrett-Mayer E, Bandyopadhyay. Dose finding clinical trial design for ordinal toxicity grades using the continuation ratio model: an extension of the continual reassessment method. Clinical Trials 2012; 9(3): 303-313. \cr
3. Garrett-Mayer E. The continual reassessment method for dose-finding studies: a tutorial. Clinical Trials 2006; 3: 57-71. \cr
4. Piantadosi S, Fisher JD, Grossman S. Practical implementation of a modified continual reassessment method for dose-finding trials. Cancer Chemother Pharmacol 1998; 41: 429-436. \cr
5. Harrell FE, Jr. Regression Modeling Strategies with Application to Linear Models, Logistic Regression, and Survival Analysis. Springer: New York, NY, 2001. \cr
6. McCullagh P. Regression Models for Ordinal Data. Journal of the Royal Statistical Society. Series B (Methodological). 1980; 42: 109-142. \cr
7. CTCAE. Cancer Therapy Evaluation Program, Common Terminology Criteria for Adverse Events, Version 4.0, DCTD, NCI, NIH, DHHS (http://ctep/cancer.gov). In Cancer Therapy Evaluation Program, 2010.
}
\seealso{
\code{\link{nextdose}}
}

