% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_betaexpg.R
\name{order_betaexpg}
\alias{order_betaexpg}
\title{Random Sampling of k-th Order Statistics from a Beta Exponential G Distribution}
\usage{
order_betaexpg(size, spec, lambda, a, b, k, n, p = 0.5, alpha = 0.05, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{spec}{character, represents an specific G distribution. Possible values "norm", "exp","lnorm","chisq".}

\item{lambda}{numeric, represents the first shape parameter. Default value is 1.}

\item{a}{numeric, represents the second shape parameter. Default value is 1.}

\item{b}{numeric, represents the third shape parameter. Default value is 1.}

\item{k}{numeric, represents the k-th smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{p}{numeric, represents the 100p percentile for the distribution of the k-th order statistic. Default value is population median, p = 0.5.}

\item{alpha}{numeric, (1 - alpha) represents the confidence of an interval for the population percentile p of the distribution of the k-th order statistic. Default value is 0.05.}

\item{...}{represents others parameters of the G distribution.}
}
\value{
A list with a random sample of order statistics from a Beta Exponential G Distribution and the value of its join probability density function evaluated in the random sample
and an approximate (1 - alpha) confidence interval for the population percentile p of the distribution of the k-th order statistic.
}
\description{
\code{order_betaexpg} is used to obtain a random sample of the k-th order statistic from a Beta Exponential G Distribution.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from
# a Beta Exponential Exponential Distribution
order_betaexpg(10,"exp",1,1,1,k=3,50,alpha=0.02)
# A sample of size 10 of the 3-th order statistics from
# a Beta Exponential Normal Distribution
order_betaexpg(10,"norm",1,1,1,k=3,50)
# A sample of size 10 of the 3-th order statistics from
# a Beta Exponential Log-normal Distribution
order_betaexpg(10,"lnorm",1,1,1,k=3,50)
# A sample of size 10 of the 3-th order statistics from
# a Beta Exponential Chi-square Distribution
order_betaexpg(10,"chisq",1,1,1,k=3,50,df=3)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statistical Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
