% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordgam_additive.R
\name{ordgam_additive}
\alias{ordgam_additive}
\title{Compute the additive terms estimated using an 'ordgam' model}
\usage{
ordgam_additive(obj.ordgam, ngrid = 300, ci.level = 0.95)
}
\arguments{
\item{obj.ordgam}{An object of class 'ordgam'.}

\item{ngrid}{Number of grid points where the additive terms are computed.}

\item{ci.level}{Credibility level for the pointwise credible region for the additive terms}
}
\value{
a list containing:
\itemize{
\item{\code{nalpha} : \verb{ }}{number of intercepts in the proportional odds model.}
\item{\code{nfixed} : \verb{ }}{number of non-penalized regression parameters in 'beta'.}
\item{\code{J} : \verb{ }}{number of additive terms.}
\item{\code{additive.lab} : \verb{ }}{labels of the additive terms.}
\item{\code{K} : \verb{ }}{number of spline parameters to specify an additive term.}
\item{\code{knots} : \verb{ }}{list of length J containing the knots for the B-spline basis associated to a given additive term.}
\item{\code{f.grid} : \verb{ }}{list of length J with, for each additive term, a list of length 2 with 'x': a vector of grid values for the covariate ; 'y.mat': a matrix with 3 columns (est,low,up) giving the additive term and its pointwise credible region}
\item{\code{f} : \verb{ }}{a list of length J with, for each additive term <x>, a list with f$x: a function computing the additive term f(x) for a given covariate value 'x' ; attributes(f$x): support, label, range.}
\item{\code{f.se} : \verb{ }}{a list of length J with, for each additive term <x>, a list with f.se$x: a function computing the s.e. of f(x) for a given covariate value 'x' ; attributes(f.se$x): support, label, range}
}
}
\description{
Compute the additive terms estimated using an 'ordgam' model
}
\examples{
library(ordgam)
data(freehmsData)
mod = ordgam(freehms ~ gndr + s(eduyrs) + s(age),
             data=freehmsData, descending=TRUE)
obj = ordgam_additive(mod)
names(obj)
with(obj$f.grid$age,
      matplot(x, y.mat, lty=c(1,2,2),type="l",col=1,
              xlab="Age", ylab="f(Age)"))

}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
