% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverseEventsQuery.R
\name{adverseEventsQuery}
\alias{adverseEventsQuery}
\title{Retrieve Adverse Events data for a specified drug.}
\usage{
adverseEventsQuery(chemblId, index = 0, size = 10)
}
\arguments{
\item{chemblId}{Character: ChEMBL ID of the target drug (e.g., "CHEMBL1016").}

\item{index}{Integer: Page index for pagination (default: 0).}

\item{size}{Integer: Number of records to retrieve (default: 10).}
}
\value{
Returns a tibble containing adverse events data for the specified drug.
}
\description{
This function queries the Open Targets GraphQL API to retrieve adverse events data
for a specified drug.
}
\examples{
\dontrun{
result <- adverseEventsQuery(chemblId = "CHEMBL1016", size = 10)
result <- adverseEventsQuery(chemblId = "CHEMBL1016", index = 0, size = 10)
}
}
