% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_skewness.R
\encoding{UTF-8}
\name{ordinal_skewness}
\alias{ordinal_skewness}
\title{Computes the estimated skewness of an ordinal time series}
\usage{
ordinal_skewness(series, states, distance = "Block", normalize = FALSE)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{distance}{A function defining the underlying distance between
states. The Hamming, block and Euclidean distances are already
implemented by means of the arguments "Hamming", "Block" (default)
and "Euclidean". Otherwise, a function taking as input two states must
be provided.}

\item{normalize}{Logical. If \code{normalize = FALSE} (default), the value of the estimated skewness is returned. Otherwise, the function
returns the normalized estimated skewness.}
}
\value{
The estimated skewness.
}
\description{
\code{ordinal_skewness} computes the estimated skewness
of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated skewness given by \eqn{\widehat{skew}_{d}=\sum_{i=0}^n\big(d(s_i,s_n)-d(s_i,s_0)\big)\widehat{p}_i},
where \eqn{d(\cdot, \cdot)} is a distance between ordinal states and \eqn{\widehat{p}_k} is the standard estimate
of the marginal probability for state \eqn{s_k} computed from the realization \eqn{\overline{X}_t}.
}
\examples{
estimated_skewness <- ordinal_skewness(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the skewness estimate
# for one series in dataset AustrianWages using the block distance
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
