% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateOutliers.R
\name{generateOutliers}
\alias{generateOutliers}
\title{Adds Outliers}
\usage{
generateOutliers(x, p = 0.05, sd_factor = 5, seed = NULL)
}
\arguments{
\item{x}{A vector, matrix or \code{data.frame}.}

\item{p}{Proportion of outliers to add to \code{x}. In case \code{x} is a \code{data.frame}, \code{p} can
also be a vector of probabilities per column or a named vector (see examples).}

\item{sd_factor}{Each outlier is generated by shifting the original value by a
realization of a normal random variable with \code{sd_factor} times
the original sample standard deviation.}

\item{seed}{An integer seed.}
}
\value{
\code{x} with outliers.
}
\description{
Takes a vector, matrix or data frame and replaces some numeric values by outliers.
}
\examples{
generateOutliers(1:10, seed = 334, p = 0.3)
generateOutliers(cbind(1:10, 10:1), p = 0.2)
head(generateOutliers(iris))
head(generateOutliers(iris, p = 0.2))
head(generateOutliers(iris, p = c(0, 0, 0.5, 0.5, 0.5)))
head(generateOutliers(iris, p = c(Sepal.Length = 0.2)))
}
\seealso{
\code{\link[=outForest]{outForest()}}
}
