% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.outForest}
\alias{plot.outForest}
\title{Plots outForest}
\usage{
\method{plot}{outForest}(x, what = c("counts", "scores"), ...)
}
\arguments{
\item{x}{An object of class "outForest".}

\item{what}{What should be plotted? Either \code{"counts"} (the default) or \code{"scores"}.}

\item{...}{Arguments passed to \code{\link[graphics:barplot]{graphics::barplot()}} or \code{\link[graphics:stripchart]{graphics::stripchart()}}.}
}
\value{
A list.
}
\description{
This function can plot aspects of an "outForest" object.
\itemize{
\item With \code{what = "counts"}, the number of outliers per variable is visualized as a
barplot.
\item With \code{what = "scores"}, outlier scores (i.e., the scaled difference between
predicted and observed value) are shown as scatterplot per variable.
}
}
\examples{
irisWithOutliers <- generateOutliers(iris, seed = 345)
x <- outForest(irisWithOutliers, verbose = 0)
plot(x)
plot(x, what = "scores")
}
