% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{matrix2adj}
\alias{matrix2adj}
\title{Convert distance matrix to adjacency dataframe}
\usage{
matrix2adj(data, quantile_cutoff = 5)
}
\arguments{
\item{data}{distance matrix}

\item{quantile_cutoff}{an integer value (1-99) for quantile cutoff}
}
\value{
adjacency dataframe (with columns "from, to, distance,direction, similarity")
}
\description{
Convert distance matrix to adjacency dataframe for network construction.
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
dtw_dist_matrix <- get_dtw_dist_mat(expression_matrix,
                                    pseudotime_list,
                                    cores=1)
adj_df <- matrix2adj(dtw_dist_matrix)

}
