% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{scale_fill_r2dii_tech}
\alias{scale_fill_r2dii_tech}
\title{Custom PACTA technology colour and fill scales}
\usage{
scale_fill_r2dii_tech(sector, technologies = NULL, ...)
}
\arguments{
\item{sector}{A string. Sector name specifying a colour palette. Run
\code{unique(r2dii.plot:::technology_colours$sector)} to see available sectors.}

\item{technologies}{A character vector. Specifies technologies to use as
colours and their order. Run
\code{unique(r2dii.plot:::technology_colours$technology)} to see available
technologies (pay attention if they match the \code{sector}). Similar to \code{value}
parameter in \code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}}.}

\item{...}{Other parameters passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\value{
An object of class "ScaleDiscrete".
}
\description{
A custom discrete colour and fill scales with colours from the PACTA technology
palette.
}
\examples{
library(ggplot2, warn.conflicts = FALSE)

ggplot(mpg) +
  geom_point(aes(displ, hwy, color = class)) +
  scale_colour_r2dii_tech("automotive")

ggplot(mpg) +
  geom_histogram(aes(cyl, fill = class), position = "dodge", bins = 5) +
  scale_fill_r2dii_tech("automotive")
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
