% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{paddle_get_update_payment_transaction}
\alias{paddle_get_update_payment_transaction}
\title{Get a transaction to update payment method}
\usage{
paddle_get_update_payment_transaction(id)
}
\arguments{
\item{id}{Character. Required. Paddle ID of the subscription (e.g. "sub_abc123").}
}
\value{
A list containing transaction details for payment method update.
}
\description{
Returns a transaction that can be passed to a checkout to update payment details.
Only for subscriptions where `collection_mode` is `automatic`.
}
\details{
Depending on subscription status:
- For `past_due`, returns the most recent failed transaction.
- For `active`, creates a new zero-amount transaction.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_get_update_payment_transaction(
  id = "sub_123"
)
\dontshow{\}) # examplesIf}
}
