% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_list_customer_businesses}
\alias{paddle_list_customer_businesses}
\title{List Businesses for a Customer}
\usage{
paddle_list_customer_businesses(
  id,
  business_id = NULL,
  status = NULL,
  after = NULL,
  order_by = NULL,
  per_page = NULL,
  search = NULL
)
}
\arguments{
\item{id}{Character. Paddle customer ID (e.g., "ctm_abc123"). Required.}

\item{business_id}{Character vector of business IDs (e.g., "biz_123"). Optional.}

\item{status}{Character. Status of the customer (`"active"` or `"archived"`). Optional.}

\item{after}{Character. Pagination cursor: return entities after this ID. Optional.}

\item{order_by}{Character. Must be one of `"id[ASC]"`, `"id[DESC]"`. Optional.}

\item{per_page}{Integer. Max number of results (default: 50, max: 200). Optional.}

\item{search}{Character. Optional search query across business fields and contacts (except status, created_at, updated_at).}
}
\value{
A list containing business data and pagination metadata.
}
\description{
Retrieves a paginated list of businesses associated with a given customer from the Paddle API.
By default, only active businesses are returned.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_customer_businesses(id = "ctm_123")
\dontshow{\}) # examplesIf}
}
