% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_species.r
\name{make.env}
\alias{make.env}
\title{Generates simulated environmental variables}
\usage{
make.env(n, elen, emean, edistr, ecor, ndim)
}
\arguments{
\item{n}{Number of samples to be generated.}

\item{elen}{Range of the environmental variables.
Single number or vector of length \code{ndim}.}

\item{emean}{Mean of the environmental variables.
Single number or vector of length \code{ndim}.}

\item{edistr}{Distribution of the environmental variables.
Currently 'uniform' and 'Gaussian' are supported.}

\item{ecor}{Correlation matrix of the environmental variables.
Object can be generated with \code{\link{cor.mat.fun}}.
If omitted environmental variables are not correlated.}

\item{ndim}{Number of environmental variables to generate.}
}
\value{
Matrix of environmental variables. \code{n} rows and \code{ndim} columns.
}
\description{
Simulates environmental variables used for generating species abundances.
Environmental variables may be correlated,
and may follow different distributions.
}
\examples{
env.vars <- make.env(100,
  elen = rep(100, 10), emean = rep(50, 10),
  edistr = "uniform", ndim = 10
)
}
\references{
Minchin, P.R. (1987) Multidimensional Community Patterns:
Towards a Comprehensive Model. \emph{Vegetatio}, \strong{71}, 145-156.
\doi{10.1007/BF00039167}
}
\seealso{
\code{\link{cor.mat.fun}}
}
\author{
Mathias Trachsel and Richard J. Telford
}
\keyword{datagen}
